#include "libvdev/misc.h"

#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

int main(int argc, char *argv[])
{
   int rc;
   int fd;
   struct flock fl;
   char lockfile[1024];
   
   if (argc != 2) {
     fprintf(stderr, "usage: vdev_wait <filename>\n");
     return 1;
   }
   /*
   else if (......) {
     fprintf(stderr, "Invalid argument '%s'\n", argv[1]);
     return 2;
   }*/

   strncpy_t (lockfile, sizeof(lockfile), argv[1], strlen(argv[1]));
   
   if (access (lockfile, F_OK ) != 0)
      return 0;
   
   fd = open(lockfile, O_RDWR);   
   memset(&fl, 0, sizeof(fl));
   
   fl.l_type = F_WRLCK; // Set a write lock
   
   fl.l_whence = SEEK_SET; // Start at beginning of file
   fl.l_start = 0; // Offset from beginning of file
   fl.l_len = 0; // Lock entire file
   
   // F_SETLK(W) ignores it; F_OFD_SETLK(W) requires it to be zero
   fl.l_pid = 0; //getpid(); // Set process ID
   
   // F_SETLKW specifies blocking mode
   rc = fcntl(fd, F_SETLKW, &fl); // Set the lock
   
   fl.l_type = F_UNLCK; // Release the lock
   rc = fcntl(fd, F_SETLK, &fl); // Unlock the file

   close(fd);
   
   unlink (lockfile);
 
   return 0;
}
