/*
   daemonlet.h
  
   All modifications to the original source file are:
    - Copyright (C) 2025 Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org> 
 
   Original copyright and license text produced below.
*/

/*
   vdev: a virtual device manager for *nix
   Copyright (C) 2015  Jude Nelson

   This program is dual-licensed: you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 3 or later as 
   published by the Free Software Foundation. For the terms of this 
   license, see LICENSE.GPLv3+ or <http://www.gnu.org/licenses/>.

   You are free to use this program under the terms of the GNU General
   Public License, but WITHOUT ANY WARRANTY; without even the implied 
   warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
   See the GNU General Public License for more details.

   Alternatively, you are free to use this program under the terms of the 
   Internet Software Consortium License, but WITHOUT ANY WARRANTY; without
   even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
   For the terms of this license, see LICENSE.ISC or 
   <http://www.isc.org/downloads/software-support-policy/isc-license/>.
*/

#ifndef _VDEV_DAEMONLET_H_
#define _VDEV_DAEMONLET_H_

#include "config.h"
#include "util.h"

struct vdev_daemonlet {
    int stdin;
    int stdout;
    pid_t pid;
};

int vdev_daemonlet_start(struct vdev_config *cfg, 
                         struct vdev_daemonlet *daemonlet, 
                         const char *command, 
                         const char *name, 
                         bool async, 
                         int *error_fd);
int vdev_daemonlet_stop(struct vdev_daemonlet *daemonlet, const char *action_name);
int vdev_daemonlet_make_env_str(char const *key, char const *value, char **ret);
int vdev_daemonlet_read_int64(int fd, int64_t *ret);
int vdev_daemonlet_send_command(char **env, 
                                int num_env, 
                                const char *name, 
                                bool async, 
                                int64_t *daemonlet_rc, 
                                struct vdev_daemonlet *daemonlet);

#endif // _VDEV_DAEMONLET_H_
