 /*
  * netlink_monitor.h
  * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
  * 
  * simple-netaid is free software: you can redistribute it and/or modify it
  * under the terms of the GNU General Public License as published by the
  * Free Software Foundation, either version 3 of the License, or
  * (at your option) any later version.
  * 
  * simple-netaid is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU General Public License for more details.
  * 
  * You should have received a copy of the GNU General Public License along
  * with this program.  If not, see <http://www.gnu.org/licenses/>.
  * 
  * See the COPYING file.
  */
   
#ifndef __NETLINK_MONITOR_H__
#define __NETLINK_MONITOR_H__

#include <stdio.h>
#include <stdlib.h>

#include "def.h"
			  
// Forward declarations
struct nlsock;

void log_netlink_event(char *buf);
void kernel_init (void);
void wired_connection_hotplug_trigger(const char *ifname);
void netlink_event_cb(struct uloop_fd *u, unsigned int events);
int netlink_link_change(struct sockaddr_nl *snl, struct nlmsghdr *h);
int netlink_interface_filter(struct sockaddr_nl *snl, struct nlmsghdr *h, struct rtattr **tb);
int netlink_parse_info(int (*filter)(struct sockaddr_nl *, struct nlmsghdr *), struct nlsock *nl);
void kernel_init(void);
void kernel_finish(void);

#endif  // __NETLINK_MONITOR_H__
