/*
 * netaid-window.h
 * Copyright(C) 2026 Aitor Cuadrado Zubizarreta <aitor@genuen.org>
 *
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * See the COPYING file. *
 */

#pragma once

#include <gtk/gtk.h>

#include <gdk/gdkx.h>  /* gdk_x11_window_get_xid(), etc */
#include <X11/Xatom.h>

G_BEGIN_DECLS

// Forward declarations
typedef struct _NetaidConfig NetaidConfig;
typedef struct _NetaidStatusIcon NetaidStatusIcon;
typedef struct _NetaidMenuBar NetaidMenuBar;
typedef struct _NetaidToolbar NetaidToolbar;
typedef struct _NetaidNotebook NetaidNotebook;

struct _NetaidWindow {
    GtkApplicationWindow     __parent__;
    
    Display *display;
    /* the XID (which is of type “Window” in X11) */
    Window xid;

    gboolean connected;
    gboolean systray_ok;
    gboolean iconified;
    GString *ifname;
    
    //gulong focus_out_handler_id;    
    guint timer_handler_id;

    GtkWidget        *label;
    NetaidConfig     *netaid_config;
    NetaidStatusIcon *status_icon;
    NetaidMenuBar    *menu_bar;
    NetaidToolbar    *toolbar;
    NetaidNotebook   *notebook;
};

typedef struct _NetaidWindow NetaidWindow;

#define NETAID_TYPE_WINDOW netaid_window_get_type()
G_DECLARE_FINAL_TYPE(NetaidWindow, netaid_window, NETAID, WINDOW, GtkApplicationWindow)
    
/* Public method prototype */
gboolean netaid_window_is_visible(NetaidWindow *);

NetaidWindow *get_netaid_window_from_xid(Window xid);
GtkWidget *netaid_window_new(GtkApplication *app, gboolean systray);
gboolean on_delete_cb(GtkWidget *widget, gpointer user_data);
gboolean on_window_delete_event_cb(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_shutdown_cb(GtkWidget *widget, gpointer user_data);
gboolean on_toggle_cb(GtkWidget *widget, gpointer user_data);
gboolean on_window_state_changed(GtkWidget *widget, GdkEventWindowState *event, gpointer data);
gboolean on_visibility_changed(GtkWidget *widget, GdkEventVisibility *event, gpointer data);
void netaid_window_status_icon_update(NetaidWindow *self);

G_END_DECLS
