/*
 * netaid-toolbar.h
 * Copyright(C) 2026 Aitor Cuadrado Zubizarreta <aitor@genuen.org>
 *
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * See the COPYING file. *
 */

#pragma once

#include <glib.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define NETAID_TYPE_TOOLBAR	        (netaid_toolbar_get_type())
#define NETAID_TOOLBAR_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), NETAID_TYPE_TOOLBAR, NetaidToolbarClass))
#define NETAID_TOOLBAR(obj)	        (G_TYPE_CHECK_INSTANCE_CAST((obj), NETAID_TYPE_TOOLBAR, NetaidToolbar))
#define NETAID_IS_TOOLBAR(obj)      (G_TYPE_CHECK_INSTANCE_TYPE((obj), NETAID_TYPE_TOOLBAR))
#define NETAID_IS_TOOLBAR_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE((k), NETAID_TYPE_TOOLBAR))
#define NETAID_TOOLBAR_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS((o), NETAID_TYPE_TOOLBAR, NetaidToolbarClass))

typedef struct _NetaidToolbarClass NetaidToolbarClass;
typedef struct _NetaidToolbar NetaidToolbar;

struct _NetaidToolbarClass {
    GtkToolbarClass __parent__;
};

struct _NetaidToolbar {
    GtkToolbar __parent__;

    gboolean connected;

    GtkToolItem *refreshTb;
    GtkToolItem *exitTb;
};

GType netaid_toolbar_get_type(void) G_GNUC_CONST;

NetaidToolbar *netaid_toolbar_new();
void netaid_toolbar_update(NetaidToolbar *toolbar);

G_END_DECLS
