/*
 * netaid-toolbar.c
 * Copyright(C) 2026 Aitor Cuadrado Zubizarreta <aitor@genuen.org>
 *
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * See the COPYING file. *
 */

#include "netaid-toolbar.h"
#include "netaid-window.h"

#include <simple-netaid/sbuf.h>
#include <simple-netaid/netproc.h>
#include <simple-netaid/iproute.h>

/* Function defined in set_icon.c */
GdkPixbuf *get_icon_view_refresh();

enum {
    PROP_0,
    PROP_CONNECTED,
    N_PROPERTIES
};

static GParamSpec *properties[N_PROPERTIES] = {NULL, };

G_DEFINE_TYPE(NetaidToolbar, netaid_toolbar, GTK_TYPE_TOOLBAR)

// Signal handler for the "property-notify-event"
static gboolean on_property_notify_event(GObject *gobject,
		GParamSpec *pspec, gpointer user_data)
{
	/*
    NetaidToolbar *toolbar =(NetaidToolbar *)gobject;
    const char *name;
    gboolean is_connected;
    name = g_param_spec_get_name(pspec);
    g_object_get(G_OBJECT(toolbar), name, &is_connected, NULL);
    if (is_connected)
        g_print(" %s = TRUE\n", name);
    else
        g_print(" %s = FALSE\n", name);
	*/
}

static void netaid_toolbar_finalize(GObject *object)
{
    G_OBJECT_CLASS(netaid_toolbar_parent_class)->finalize(object);
}

static void netaid_toolbar_constructed(GObject *object)
{
    G_OBJECT_CLASS(netaid_toolbar_parent_class)->constructed(object);
}

static void netaid_toolbar_set_property(GObject *object,
		guint property_id, const GValue *value, GParamSpec *pspec)
{
    NetaidToolbar *self = NETAID_TOOLBAR(object);

    if (property_id == PROP_CONNECTED)
        self->connected = g_value_get_boolean(value);
    else
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, property_id, pspec);
}

static void netaid_toolbar_get_property(GObject *object,
		guint property_id, GValue *value, GParamSpec *pspec)
{
    NetaidToolbar *self = NETAID_TOOLBAR(object);

    if (property_id == PROP_CONNECTED)
        g_value_set_boolean(value, self->connected);
    else
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, property_id, pspec);
}

static void netaid_toolbar_class_init(NetaidToolbarClass *klass)
{
    GObjectClass *object_class = G_OBJECT_CLASS(klass);
    GtkToolbarClass *toolbar_class = GTK_TOOLBAR_CLASS(klass);
    GtkContainerClass *container_class = GTK_CONTAINER_CLASS(klass);
    GtkWidgetClass *widget_class = GTK_WIDGET_CLASS(klass);

    object_class->constructed = netaid_toolbar_constructed;
    object_class->finalize = netaid_toolbar_finalize;
    object_class->set_property = netaid_toolbar_set_property;
    object_class->get_property = netaid_toolbar_get_property;

    properties[PROP_CONNECTED] = g_param_spec_boolean("connected", NULL, NULL,
            TRUE,
            G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS
            /* | G_PARAM_EXPLICIT_NOTIFY */);

    g_object_class_install_properties(object_class, N_PROPERTIES, properties);
}

static void netaid_toolbar_init(NetaidToolbar *self)
{
    GtkWidget *image1;
    GtkToolItem *sep;
    gtk_toolbar_set_style(GTK_TOOLBAR(self), GTK_TOOLBAR_ICONS);

    image1 = gtk_image_new_from_pixbuf(get_icon_view_refresh());
    self->refreshTb = gtk_tool_button_new(image1, NULL);
    gtk_widget_set_tooltip_text(GTK_WIDGET(self->refreshTb), 
			"Refresh the list of active wifis");
    gtk_widget_set_has_tooltip(GTK_WIDGET(self->refreshTb), TRUE);
    gtk_toolbar_insert(GTK_TOOLBAR(self), self->refreshTb, -1);

    sep = gtk_separator_tool_item_new();
    gtk_toolbar_insert(GTK_TOOLBAR(self), sep, -1);

    self->exitTb = gtk_tool_button_new_from_stock(GTK_STOCK_QUIT);
    gtk_toolbar_insert(GTK_TOOLBAR(self), self->exitTb, -1);

    netaid_toolbar_update(self);

    g_signal_connect(G_OBJECT(self), "notify::connected",
			G_CALLBACK(on_property_notify_event), NULL);

    gtk_widget_show_all(GTK_WIDGET(self));
}

NetaidToolbar *netaid_toolbar_new()
{
    NetaidToolbar *toolbar;

    toolbar = g_object_new(NETAID_TYPE_TOOLBAR, NULL);

    return NETAID_TOOLBAR(toolbar);
}

void netaid_toolbar_update(NetaidToolbar *toolbar)
{

}
