/*
 * netaid-status-icon.h
 * Copyright(C) 2026 Aitor Cuadrado Zubizarreta <aitor@genuen.org>
 *
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * See the COPYING file. *
 */

#pragma once

#include <glib.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS;

#define NETAID_TYPE_STATUS_ICON	        (netaid_status_icon_get_type())
#define NETAID_STATUS_ICON_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), NETAID_TYPE_STATUS_ICON, NetaidStatusIconClass))
#define NETAID_STATUS_ICON(obj)	        (G_TYPE_CHECK_INSTANCE_CAST((obj), NETAID_TYPE_STATUS_ICON, NetaidStatusIcon))
#define NETAID_IS_STATUS_ICON(obj)      (G_TYPE_CHECK_INSTANCE_TYPE((obj), NETAID_TYPE_STATUS_ICON))
#define NETAID_IS_STATUS_ICON_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE((k), NETAID_TYPE_STATUS_ICON))
#define NETAID_STATUS_ICON_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS((o), NETAID_TYPE_STATUS_ICON, NetaidStatusIconClass))


typedef struct _NetaidStatusIconClass NetaidStatusIconClass;
typedef struct _NetaidStatusIcon NetaidStatusIcon;


struct _NetaidStatusIconClass{
    GtkStatusIconClass  __parent__;
};

struct  _NetaidStatusIcon{
    GtkStatusIcon  __parent__;
    
    GtkWidget *menu;
    GtkWidget *menuItemShow;
    GtkWidget *menuItemExit;
};


GType netaid_status_icon_get_type(void) G_GNUC_CONST;

NetaidStatusIcon *netaid_status_icon_new();

void on_status_icon_popup(GtkStatusIcon *status_icon, guint button,
        guint32 activate_time, gpointer popUpMenu);
void on_menu_closed(GtkMenu *menu, gpointer user_data);

G_END_DECLS;
