/*
 * netaid-status-icon.c
 * Copyright(C) 2026 Aitor Cuadrado Zubizarreta <aitor@genuen.org>
 *
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * See the COPYING file. *
 */

#include "netaid-status-icon.h"
#include "netaid-window.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <errno.h>

#include <simple-netaid/netproc.h>
#include <simple-netaid/iproute.h>

G_DEFINE_TYPE(NetaidStatusIcon, netaid_status_icon, GTK_TYPE_STATUS_ICON)

static void netaid_status_icon_finalize(GObject *object)
{
    NetaidStatusIcon *self = NETAID_STATUS_ICON(object);

    G_OBJECT_CLASS( netaid_status_icon_parent_class)->finalize(object);
}

static void netaid_status_icon_constructed(GObject *object)
{
    G_OBJECT_CLASS(netaid_status_icon_parent_class)->constructed(object);
}

static void netaid_status_icon_class_init(NetaidStatusIconClass *klass)
{
    GObjectClass *object_class = G_OBJECT_CLASS(klass);
    GtkStatusIconClass *status_icon_class = GTK_STATUS_ICON_CLASS(klass);

    object_class->constructed = netaid_status_icon_constructed;
    object_class->finalize = netaid_status_icon_finalize;
}

static void netaid_status_icon_init(NetaidStatusIcon *self)
{
    gtk_status_icon_set_visible(GTK_STATUS_ICON(self), TRUE);
    gtk_status_icon_set_has_tooltip(GTK_STATUS_ICON(self), TRUE);

    self->menu = gtk_menu_new();
    self->menuItemShow = gtk_menu_item_new_with_label("Hide");
    self->menuItemExit = gtk_image_menu_item_new_from_stock(GTK_STOCK_QUIT, NULL);

    // packing
    gtk_menu_shell_append(GTK_MENU_SHELL(self->menu), self->menuItemShow);
    gtk_menu_shell_append(GTK_MENU_SHELL(self->menu), self->menuItemExit);

    gtk_widget_show_all(self->menu);
}

NetaidStatusIcon *netaid_status_icon_new()
{
    NetaidStatusIcon *status_icon;
    status_icon = g_object_new(NETAID_TYPE_STATUS_ICON, NULL);
    return NETAID_STATUS_ICON(status_icon);
}

void on_status_icon_popup(GtkStatusIcon *status_icon, 
		guint button, guint32 activate_time, gpointer user_data)
{
    g_return_if_fail(NETAID_IS_WINDOW(user_data));

    NetaidWindow *window = NETAID_WINDOW(user_data);
    
    gboolean is_iconified;
    g_object_get(G_OBJECT(window), "iconified", &is_iconified, NULL);

    if (is_iconified)
        gtk_menu_item_set_label((GtkMenuItem *)window->status_icon->menuItemShow, "Show");
    else
        gtk_menu_item_set_label((GtkMenuItem *)window->status_icon->menuItemShow, "Hide");

    gtk_menu_popup(GTK_MENU(window->status_icon->menu), NULL, NULL,
			gtk_status_icon_position_menu, status_icon, button, activate_time);
}

