/* 
  netaid-pixbuf.c -- Copyright(C) 2019 Didier Kryn <kryn@in2p3.fr>
  
  Permission to  use, copy, modify, distribute, and sell this software and its
  documentation for any purpose  is hereby granted without fee,  provided that
  the above copyright notice appear in all copies and that both that copyright
  notice and this permission notice appear in supporting documentation.
  
  The above copyright notice  and this permission notice  shall be included in
  all copies or substantial portions of the Software.
  
  THE SOFTWARE IS PROVIDED  "AS IS",  WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING  BUT NOT LIMITED  TO  THE WARRANTIES OF  MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE  AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  COPYRIGHT HOLDERS  BE LIABLE  FOR ANY  CLAIM,  DAMAGES  OR OTHER  LIABILITY,
  WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
  IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
  
  Except as contained  in this notice, the name of copyright holders shall not
  be used  in  advertising  or  otherwise  to promote  the sale,  use or other
  dealings  in this  Software  without prior  written  authorization  from the
  copyright holders.
  
  ----------------------------------------------------------------------------

  Go to the git repository for more info:

  https://git.devuan.org/kryn/hopman.git 

  All modifications to the original source file are:
  Copyright(C) 2026 Aitor Cuadrado Zubizarreta <aitor@genuen.org>

*/

#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>

static guint32 u8tou32(const guint8* b)
{
    guint32 u;
    int i;
    for (u=*b, i=1; i<4; i++)
    {
        u <<= 8;
        u |= * (b+i);
    }
    return u;
}

/*   PIXBUF DATA  */
#include "app_16x16"
#include "brand_16x16"
#include "connected_16x16"
#include "disconnected_16x16"
#include "view_refresh_16x16"
#include "wired_16x16"

/*================= Destructor(dummy because data is static) ===============*/
void nop_destroy(guchar *pixels, gpointer data)
{
  /* NO OP */
}

GdkPixbuf *get_app_icon()
{
    GdkPixbuf *pPix;
    const char *magic = "GdkP";
    int i;
    guint32 total_len, pixdata_type, width, height, rowstride;
    const guint8 *pixeldata;

    if (strncmp(app_16x16, magic, 4)) {
        fprintf(stderr, "Error in function set-icon(): invalid Gdk pixbuf.\n");
        exit(EXIT_FAILURE);
    }

    total_len = u8tou32(app_16x16+4);
    pixdata_type = u8tou32(app_16x16+8);
    rowstride = u8tou32(app_16x16+12);
    width = u8tou32(app_16x16+16);
    height = u8tou32(app_16x16+20);
    pixeldata = app_16x16+24;

    pPix=gdk_pixbuf_new_from_data(pixeldata, GDK_COLORSPACE_RGB, TRUE, 8,
                                width, height, rowstride, nop_destroy, NULL);

    return pPix;
}

GdkPixbuf *get_brand_icon()
{
    GdkPixbuf *pPix;
    const char *magic = "GdkP";
    int i;
    guint32 total_len, pixdata_type, width, height, rowstride;
    const guint8 *pixeldata;

    if (strncmp(brand_16x16, magic, 4)) {
        fprintf(stderr, "Error in function set-icon(): invalid Gdk pixbuf.\n");
        exit(EXIT_FAILURE);
    }

    total_len = u8tou32(app_16x16+4);
    pixdata_type = u8tou32(app_16x16+8);
    rowstride = u8tou32(app_16x16+12);
    width = u8tou32(app_16x16+16);
    height = u8tou32(app_16x16+20);
    pixeldata = app_16x16+24;

    pPix=gdk_pixbuf_new_from_data(pixeldata, GDK_COLORSPACE_RGB, TRUE, 8,
                                width, height, rowstride, nop_destroy, NULL);

    return pPix;
}

GdkPixbuf *get_icon_connected()
{
    GdkPixbuf *pPix;
    const char *magic = "GdkP";
    int i;
    guint32 total_len, pixdata_type, width, height, rowstride;
    const guint8 *pixeldata;

    if (strncmp(connected_16x16, magic, 4)) {
        fprintf(stderr, "Error in function set-icon(): invalid Gdk pixbuf.\n");
        exit(EXIT_FAILURE);
    }

    total_len = u8tou32(connected_16x16+4);
    pixdata_type = u8tou32(connected_16x16+8);
    rowstride = u8tou32(connected_16x16+12);
    width = u8tou32(connected_16x16+16);
    height = u8tou32(connected_16x16+20);
    pixeldata = connected_16x16+24;

    pPix=gdk_pixbuf_new_from_data(pixeldata, GDK_COLORSPACE_RGB, TRUE, 8,
                                width, height, rowstride, nop_destroy, NULL);

    return pPix;
}

GdkPixbuf *get_icon_disconnected()
{
    GdkPixbuf *pPix;
    const char *magic = "GdkP";
    int i;
    guint32 total_len, pixdata_type, width, height, rowstride;
    const guint8 *pixeldata;

    if (strncmp(disconnected_16x16, magic, 4)) {
        fprintf(stderr, "Error in function set-icon(): invalid Gdk pixbuf.\n");
        exit(EXIT_FAILURE);
    }

    total_len = u8tou32(disconnected_16x16+4);
    pixdata_type = u8tou32(disconnected_16x16+8);
    rowstride = u8tou32(disconnected_16x16+12);
    width = u8tou32(disconnected_16x16+16);
    height = u8tou32(disconnected_16x16+20);
    pixeldata = disconnected_16x16+24;

    pPix = gdk_pixbuf_new_from_data(pixeldata, GDK_COLORSPACE_RGB, TRUE, 8,
                                width, height, rowstride, nop_destroy, NULL);

    return pPix;
}

GdkPixbuf *get_icon_view_refresh()
{
    GdkPixbuf *pPix;
    const char *magic = "GdkP";
    int i;
    guint32 total_len, pixdata_type, width, height, rowstride;
    const guint8 *pixeldata;

    if (strncmp(view_refresh_16x16, magic, 4))
    {
        fprintf(stderr, "Error in function set-icon(): invalid Gdk pixbuf.\n");
        exit(EXIT_FAILURE);
    }

    total_len = u8tou32(view_refresh_16x16+4);
    pixdata_type = u8tou32(view_refresh_16x16+8);
    rowstride = u8tou32(view_refresh_16x16+12);
    width = u8tou32(view_refresh_16x16+16);
    height = u8tou32(view_refresh_16x16+20);
    pixeldata = view_refresh_16x16+24;

    pPix = gdk_pixbuf_new_from_data(pixeldata, GDK_COLORSPACE_RGB, TRUE, 8,
                                width, height, rowstride, nop_destroy, NULL);

    return pPix;
}

GdkPixbuf *get_icon_wired()
{
    GdkPixbuf *pPix;
    const char *magic = "GdkP";
    int i;
    guint32 total_len, pixdata_type, width, height, rowstride;
    const guint8 *pixeldata;

    if (strncmp(wired_16x16, magic, 4)) {
        fprintf(stderr, "Error in function set-icon(): invalid Gdk pixbuf.\n");
        exit(EXIT_FAILURE);
    }

    total_len = u8tou32(wired_16x16+4);
    pixdata_type = u8tou32(wired_16x16+8);
    rowstride = u8tou32(wired_16x16+12);
    width = u8tou32(wired_16x16+16);
    height = u8tou32(wired_16x16+20);
    pixeldata = wired_16x16+24;

    pPix = gdk_pixbuf_new_from_data(pixeldata, GDK_COLORSPACE_RGB, TRUE, 8,
                                width, height, rowstride, nop_destroy, NULL);

    return pPix;
}
