/*
 * netaid-password-dialog.h
 * Copyright(C) 2026 Aitor Cuadrado Zubizarreta <aitor@genuen.org>
 *
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * See the COPYING file. *
 */

#pragma once

#include <glib.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define NETAID_TYPE_PASSWORD_DIALOG	        (netaid_password_dialog_get_type())
#define NETAID_PASSWORD_DIALOG_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), NETAID_TYPE_PASSWORD_DIALOG, NetaidPasswordDialogClass))
#define NETAID_PASSWORD_DIALOG(obj)	        (G_TYPE_CHECK_INSTANCE_CAST((obj), NETAID_TYPE_PASSWORD_DIALOG, NetaidPasswordDialog))
#define NETAID_IS_PASSWORD_DIALOG(obj)      (G_TYPE_CHECK_INSTANCE_TYPE((obj), NETAID_TYPE_PASSWORD_DIALOG))
#define NETAID_IS_PASSWORD_DIALOG_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE((k), NETAID_TYPE_PASSWORD_DIALOG))
#define NETAID_PASSWORD_DIALOG_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS((o), NETAID_TYPE_PASSWORD_DIALOG, NetaidPasswordDialogClass))

typedef struct _NetaidPasswordDialogClass NetaidPasswordDialogClass;
typedef struct _NetaidPasswordDialog NetaidPasswordDialog;

struct _NetaidPasswordDialogClass {
    GtkDialogClass __parent__;
};

struct _NetaidPasswordDialog {
    GtkDialog __parent__;

    char *essid;
    gboolean key;

    GtkWidget *entry;
    GtkWidget *label;
    GtkWidget *check_button;
    GtkWidget *connect_button;
    GtkWidget *connect_and_save_button;
    GtkWidget *cancel_button;
};

GType netaid_password_dialog_get_type(void) G_GNUC_CONST;

NetaidPasswordDialog *netaid_password_dialog_new(GtkWindow *window, const gchar *essid, gboolean key);
void on_dialog_destroy(GtkWidget *widget, gpointer user_data);
void update_button_cb(GObject *object, GParamSpec *pspec, gpointer user_data);
void check_button_pressed_cb(GtkButton *widget, gpointer user_data);
void connect_button_pressed_cb(GtkWidget *widget, gpointer user_data);
void connect_and_save_button_pressed_cb(GtkWidget *widget, gpointer user_data);

G_END_DECLS
