/*
 * netaid-notebook.h
 * Copyright(C) 2026 Aitor Cuadrado Zubizarreta <aitor@genuen.org>
 *
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * See the COPYING file. *
 */

#pragma once

#include <glib.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

// Forward declaration
typedef struct _NetaidActiveWifis NetaidActiveWifis;
typedef struct _NetaidSavedWifis NetaidSavedWifis;

#define NETAID_TYPE_NOTEBOOK	     (netaid_notebook_get_type())
#define NETAID_NOTEBOOK_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), NETAID_TYPE_NOTEBOOK, NetaidNotebookClass))
#define NETAID_NOTEBOOK(obj)	     (G_TYPE_CHECK_INSTANCE_CAST((obj), NETAID_TYPE_NOTEBOOK, NetaidNotebook))
#define NETAID_IS_NOTEBOOK(obj)      (G_TYPE_CHECK_INSTANCE_TYPE((obj), NETAID_TYPE_NOTEBOOK))
#define NETAID_IS_NOTEBOOK_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE((k), NETAID_TYPE_NOTEBOOK))
#define NETAID_NOTEBOOK_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS((o), NETAID_TYPE_NOTEBOOK, NetaidNotebookClass))

typedef struct _NetaidNotebookClass NetaidNotebookClass;
typedef struct _NetaidNotebook NetaidNotebook;

struct _NetaidNotebookClass {
    GtkNotebookClass __parent__;
};

struct _NetaidNotebook {
    GtkNotebook __parent__;    
    
    GtkWidget *connect_button;
    GtkWidget *remove_button;
    GtkWidget *rename_button;

    GtkWidget *spinner;
    NetaidActiveWifis *active_wifis;
    NetaidSavedWifis *saved_wifis;
};

GType netaid_notebook_get_type(void) G_GNUC_CONST;

NetaidNotebook *netaid_notebook_new();
void saved_connect_button_pressed_cb(GtkWidget *widget, gpointer user_data);
void saved_remove_button_pressed_cb(GtkWidget *widget, gpointer user_data);

G_END_DECLS
