/*
 * netaid-notebook.c
 * Copyright(C) 2026 Aitor Cuadrado Zubizarreta <aitor@genuen.org>
 *
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * See the COPYING file. *
 */

#include "netaid-notebook.h"
#include "netaid-active-wifis.h"
#include "netaid-saved-wifis.h"
#include "netaid-window.h"
#include "netaid-config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <signal.h>
#include <unistd.h>
#include <errno.h>
#include <assert.h>
#include <sys/wait.h>

#include <simple-netaid/sbuf.h>
#include <simple-netaid/netproc.h>
#include <simple-netaid/iproute.h>


G_DEFINE_TYPE(NetaidNotebook, netaid_notebook, GTK_TYPE_NOTEBOOK)

static void netaid_notebook_finalize(GObject *object)
{
    G_OBJECT_CLASS(netaid_notebook_parent_class)->finalize(object);
}

static void netaid_notebook_constructed(GObject *object)
{
    G_OBJECT_CLASS(netaid_notebook_parent_class)->constructed(object);
}

static void netaid_notebook_class_init(NetaidNotebookClass *klass)
{
    GObjectClass *object_class = G_OBJECT_CLASS(klass);
    GtkNotebookClass *notebook_class = GTK_NOTEBOOK_CLASS(klass);
    GtkContainerClass *container_class = GTK_CONTAINER_CLASS(klass);
    GtkWidgetClass *widget_class = GTK_WIDGET_CLASS(klass);

    object_class->constructed = netaid_notebook_constructed;
    object_class->finalize = netaid_notebook_finalize;
}

static void netaid_notebook_init(NetaidNotebook *self)
{
    GtkWidget *align;
    GtkWidget *box1, *box2, *box3;
    GtkWidget *label1, *label2;
    GtkWidget *scrolled_window1, *scrolled_window2;
    GtkWidget* table;

    gtk_notebook_set_scrollable(GTK_NOTEBOOK(self), TRUE);

    label1 = gtk_label_new_with_mnemonic("  Active Wifis  ");
    box1 = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    gtk_box_set_homogeneous(GTK_BOX(box1), TRUE);
    scrolled_window1 = gtk_scrolled_window_new(NULL, NULL);
    gtk_widget_set_hexpand(GTK_WIDGET(scrolled_window1), TRUE);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window1),
                                    GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
    gtk_box_pack_start(GTK_BOX(box1), scrolled_window1, TRUE, TRUE, 0);
    gtk_notebook_append_page(GTK_NOTEBOOK(self), box1, label1);
    self->active_wifis = netaid_active_wifis_new();
    gtk_container_add(GTK_CONTAINER(scrolled_window1), GTK_WIDGET(self->active_wifis));

    self->spinner = gtk_spinner_new();
    gtk_box_pack_start(GTK_BOX(box1), GTK_WIDGET(self->spinner), TRUE, TRUE, 5);
    gtk_spinner_stop(GTK_SPINNER(self->spinner));
    gtk_widget_hide(GTK_WIDGET(self->spinner));

    label2 = gtk_label_new_with_mnemonic("  Installed Wifis  ");
    box2 = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
    gtk_box_set_homogeneous(GTK_BOX(box2), FALSE);
    scrolled_window2 = gtk_scrolled_window_new(NULL, NULL);
    gtk_widget_set_vexpand(GTK_WIDGET(scrolled_window2), TRUE);
    gtk_widget_set_hexpand(GTK_WIDGET(scrolled_window2), TRUE);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window2),
                                    GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
    gtk_box_pack_start(GTK_BOX(box2), scrolled_window2, TRUE, TRUE, 0);
    gtk_notebook_append_page(GTK_NOTEBOOK(self), box2, label2);
    self->saved_wifis = netaid_saved_wifis_new();
    gtk_container_add(GTK_CONTAINER(scrolled_window2), GTK_WIDGET(self->saved_wifis));

    table = gtk_grid_new();

    self->connect_button = gtk_button_new_with_label("Connect");
    self->remove_button = gtk_button_new_with_label("Remove");
    self->rename_button = gtk_button_new_with_label("Rename");
	
    g_signal_connect(self->connect_button, "clicked",
            G_CALLBACK(saved_connect_button_pressed_cb), self);
	
    g_signal_connect(self->remove_button, "clicked",
            G_CALLBACK(saved_remove_button_pressed_cb), self);

    gtk_grid_set_column_spacing(GTK_GRID(table), 10);
    gtk_box_pack_start(GTK_BOX(box2), table, FALSE, FALSE, 20);
    gtk_widget_set_margin_top(GTK_WIDGET(self->connect_button), 25);
    gtk_widget_set_margin_top(GTK_WIDGET(self->remove_button), 15);
    gtk_widget_set_margin_top(GTK_WIDGET(self->rename_button), 15);
    gtk_grid_attach(GTK_GRID(table), self->connect_button, 3, 3, 1, 1);
    gtk_grid_attach(GTK_GRID(table), self->remove_button, 3, 6, 1, 1);
    gtk_grid_attach(GTK_GRID(table), self->rename_button, 3, 9, 1, 1);

    gtk_widget_show_all(GTK_WIDGET(self));
}

NetaidNotebook *netaid_notebook_new()
{
    NetaidNotebook *notebook;

    notebook = g_object_new(NETAID_TYPE_NOTEBOOK, NULL);

    return NETAID_NOTEBOOK(notebook);
}

void saved_connect_button_pressed_cb(GtkWidget *widget, gpointer user_data)
{
    NetaidNotebook *self =(NetaidNotebook *)user_data;
    GtkWidget *window = gtk_widget_get_ancestor(GTK_WIDGET(self), NETAID_TYPE_WINDOW);

    if (GTK_IS_WINDOW(window)) {
		NetaidWindow *parent = NETAID_WINDOW(window);
		netaid_config_spawn_async_command(NETAID_CONFIG(parent->netaid_config),
				parent->netaid_config->p.wireless_connection, NULL, NULL, self->saved_wifis->file);
	}
}

void saved_remove_button_pressed_cb(GtkWidget *widget, gpointer user_data)
{
    NetaidNotebook *self =(NetaidNotebook *)user_data;   
    GtkWidget *window = gtk_widget_get_ancestor(GTK_WIDGET(self), NETAID_TYPE_WINDOW);

    if (GTK_IS_WINDOW(window)) {
        GtkWidget *dialog;
        gint response;

        dialog = gtk_message_dialog_new (GTK_WINDOW(window),
                    GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                    GTK_MESSAGE_QUESTION, GTK_BUTTONS_OK_CANCEL,
                    "Are you sure you want to delete \"%s\"?", self->saved_wifis->file);

        response = gtk_dialog_run(GTK_DIALOG (dialog));
        gtk_widget_destroy(dialog);
        dialog = NULL;

        if (response == GTK_RESPONSE_OK) {
            NetaidWindow *parent = NETAID_WINDOW(window);
            netaid_config_spawn_async_command(NETAID_CONFIG(parent->netaid_config),
                    parent->netaid_config->p.uninstall, NULL, NULL, self->saved_wifis->file);
        }
    }
    
    GtkTreeSelection *selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self->saved_wifis));
    gtk_tree_selection_unselect_all(selection);
}

