/*
 * netaid-menu-bar.h
 * Copyright(C) 2026 Aitor Cuadrado Zubizarreta <aitor@genuen.org>
 *
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * See the COPYING file. *
 */

#pragma once

#include <glib.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define NETAID_TYPE_MENU_BAR	     (netaid_menu_bar_get_type())
#define NETAID_MENU_BAR_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), NETAID_TYPE_MENU_BAR, NetaidMenuBarClass))
#define NETAID_MENU_BAR(obj)	     (G_TYPE_CHECK_INSTANCE_CAST((obj), NETAID_TYPE_MENU_BAR, NetaidMenuBar))
#define NETAID_IS_MENU_BAR(obj)      (G_TYPE_CHECK_INSTANCE_TYPE((obj), NETAID_TYPE_MENU_BAR))
#define NETAID_IS_MENU_BAR_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE((k), NETAID_TYPE_MENU_BAR))
#define NETAID_MENU_BAR_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS((o), NETAID_TYPE_MENU_BAR, NetaidMenuBarClass))

typedef struct _NetaidMenuBarClass NetaidMenuBarClass;
typedef struct _NetaidMenuBar NetaidMenuBar;

struct _NetaidMenuBarClass {
    GtkMenuBarClass __parent__;
};

struct _NetaidMenuBar {
    GtkMenuBar __parent__;

    gboolean connected;

    GtkWidget *wired_connection;
    GtkWidget *disconnect;
    GtkWidget *quit;
    GtkWidget *about;
};

GType netaid_menu_bar_get_type(void) G_GNUC_CONST;

NetaidMenuBar *netaid_menu_bar_new();

void netaid_menu_bar_update(NetaidMenuBar *menu_bar);
void show_message_cb(GtkMenuItem *item, gpointer user_data);
void on_wired_connection_cb(GtkWidget *widget, gpointer user_data);
void on_disconnect_cb(GtkWidget *widget, gpointer user_data);
void on_about_cb(GtkWidget *widget, gpointer user_data);

G_END_DECLS
