/*
 * netaid-config.h
 * Copyright(C) 2026 Aitor Cuadrado Zubizarreta <aitor@genuen.org>
 *
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * See the COPYING file. *
 */

#pragma once

#include <glib-object.h>

G_BEGIN_DECLS

typedef struct {
    /* devices */
    char *wired_device;
    char *wireless_device;

    /* commands */
    char *wired_on;
    char *wired_off;
    char *wireless_on;
    char *wireless_off;
    char *wired_connection;
    char *wireless_connection;
    char *disconnect;
    char *iwlist_scanning;
    char *uninstall;
    char *netlink_monitor;

    /* paths */
    char *path_to_icons;
} Config;

#define NETAID_TYPE_CONFIG	          (netaid_config_get_type())
#define NETAID_CONFIG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), NETAID_TYPE_CONFIG, NetaidConfigClass))
#define NETAID_CONFIG(obj)	          (G_TYPE_CHECK_INSTANCE_CAST((obj), NETAID_TYPE_CONFIG, NetaidConfig))
#define NETAID_IS_CONFIG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), NETAID_TYPE_CONFIG))
#define NETAID_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), NETAID_TYPE_CONFIG))
#define NETAID_CONFIG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), NETAID_TYPE_CONFIG, NetaidConfigClass))

typedef struct _NetaidConfigClass NetaidConfigClass;
typedef struct _NetaidConfig NetaidConfig;

struct _NetaidConfigClass {
    GObjectClass __parent__;
};

struct _NetaidConfig {
    GObject __parent__;

    Config p;
};

GType netaid_config_get_type(void) G_GNUC_CONST;

NetaidConfig *netaid_config_new();
int netaid_config_ini_parser(void *p, const char *section, const char *name, const char* value);
void netaid_config_parse_command(NetaidConfig *self, GString *g_str, 
            const char *essid, const char *password, const char *filename);
void netaid_config_spawn_async_command(NetaidConfig *self, const char *command,
            const char *essid, const char *password, const char *filename);
NetaidConfig *netaid_config_new();
int netaid_config_free(Config *p);

G_END_DECLS
