/*
 * netaid-active-wifis.h
 * Copyright(C) 2026 Aitor Cuadrado Zubizarreta <aitor@genuen.org>
 *
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * See the COPYING file. *
 */

#pragma once

#include <gtk/gtk.h>

G_BEGIN_DECLS

// Forward declaration:
typedef struct _NetaidPasswordDialog NetaidPasswordDialog;

#define NETAID_TYPE_ACTIVE_WIFIS	        (netaid_active_wifis_get_type())
#define NETAID_ACTIVE_WIFIS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), NETAID_TYPE_ACTIVE_WIFIS, NetaidActiveWifisClass))
#define NETAID_ACTIVE_WIFIS(obj)	        (G_TYPE_CHECK_INSTANCE_CAST((obj), NETAID_TYPE_ACTIVE_WIFIS, NetaidActiveWifis))
#define NETAID_IS_ACTIVE_WIFIS(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), NETAID_TYPE_ACTIVE_WIFIS))
#define NETAID_IS_ACTIVE_WIFIS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), NETAID_TYPE_ACTIVE_WIFIS))
#define NETAID_ACTIVE_WIFIS_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), NETAID_TYPE_ACTIVE_WIFIS, NetaidActiveWifisClass))

typedef struct _NetaidActiveWifisClass NetaidActiveWifisClass;
typedef struct _NetaidActiveWifis NetaidActiveWifis;

struct _NetaidActiveWifisClass {
    GtkTreeViewClass __parent__;
};

struct _NetaidActiveWifis {
    GtkTreeView __parent__;

    gchar *info;
    GtkListStore *store;
    NetaidPasswordDialog *dialog;
};

GType netaid_active_wifis_get_type(void) G_GNUC_CONST;

NetaidActiveWifis *netaid_active_wifis_new();
void update_clicked_cb(GtkWidget *widget, gpointer user_data);
void on_press_event_cb(GtkTreeView *self, GtkTreePath *path,
                        GtkTreeViewColumn *col, gpointer user_data);

G_END_DECLS
