/*
 * main.c
 * Copyright(C) 2026 Aitor Cuadrado Zubizarreta <aitor@genuen.org>
 *
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * See the COPYING file. *
 */

#include <stdio.h>
#include <glib/gi18n.h>
#include "netaid-window.h"

const char * const progname = "simple-netaid-gtk";
const char * const wifi_dir = "/etc/network/wifi";

static gboolean systray_ok = FALSE;

static const GOptionEntry entries[] = {
    { "systray", 's', 0, G_OPTION_ARG_NONE, &systray_ok, "run in the systray", NULL },
    { NULL }
};

static void on_activate(GtkApplication *app, gpointer user_data)
{
    GtkWidget *window = user_data;

    g_assert(GTK_IS_APPLICATION(app));

    /* Get the current window. If there is not one, we will create it. */
    window = GTK_WIDGET(gtk_application_get_active_window(app));
    if (window == NULL)
        window = netaid_window_new(app, systray_ok);
}

#define APPLICATION_ID "org.gitlab.Netaid"

int main(int argc, char *argv[])
{
    GtkApplication *app = NULL;
    GtkWidget *window = NULL;
    int stat;

    app = gtk_application_new(APPLICATION_ID, G_APPLICATION_DEFAULT_FLAGS);
    g_application_add_main_option_entries(G_APPLICATION(app), entries);
    g_signal_connect(app, "activate", G_CALLBACK(on_activate), window);

    stat = g_application_run(G_APPLICATION(app), argc, argv);

    /*
     * Do not unref in case we use `g_autoptr(GtkApplication) app`
     * instead of `GtkApplication *app`
     */
    g_object_unref(app);

    return stat;
}

