/*
 * globals.h
 * Copyright (C) 2026 Aitor Cuadrado Zubizarreta <aitor@genuen.org>
 * 
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */

  
#ifndef __GLOBALS_H__
#define __GLOBALS_H__

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

#include <stdbool.h>

/*-------------------------- Global constants --------------------------------*/
extern const char * const progname;
extern const char * const wifi_dir;

/*--------------------- Internationalization --------------------------------*/
#include <locale.h>
#include <libintl.h>
#define _(StRiNg)  dgettext("simple-netaid-gtk", StRiNg)

#endif  // __GLOBALS_H__
