/*
 * interfaces.h
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor@genuen.org>
 * 
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */

#ifndef __INTERFACES_H__
#define __INTERFACES_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#include <sys/ioctl.h>
#include <sys/stat.h>

#include "sbuf.h"

// Forward declaration:
struct sbuf;

void get_interfaces(sbuf_t*, sbuf_t*);
void interface_up (const char*);
void interface_down (const char*);
bool get_interface_status(const char*);

#endif /* __INTERFACES_H__ */
